Rem
Rem Copyright (c) 2003, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      enq_rowlcr.sql - enqueues a ROW LCR for this sample.
Rem
Rem    DESCRIPTION
Rem      This script creates a ROW LCR and enqueues it to the queue
Rem      MGWUSER.MGW_LCR_SRC.
Rem

set serveroutput on;
declare
    enqueue_options      dbms_aq.enqueue_options_t;
    message_properties   dbms_aq.message_properties_t;
    msgid                RAW(16);
    payload		 sys.anydata;
    lcrInText            varchar2(2000) := null;
    lcrInXml             XMLType;
    lcrInAnyData         Anydata;
begin
    lcrInText :=
      '<ROW_LCR xmlns="http://xmlns.oracle.com/streams/schemas/lcr"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xsi:schemaLocation="http://xmlns.oracle.com/streams/schemas/lcr
            http://xmlns.oracle.com/streams/schemas/lcr/streamslcr.xsd">

            <source_database_name>DBS1.REGRESS.RDBMS.DEV.US.ORACLE.COM</source_database_name>
            <command_type>INSERT</command_type>
            <object_owner>PINK_APP</object_owner>
            <object_name>DUMMY</object_name>
            <transaction_id>3.0.1205</transaction_id>
            <scn>200058</scn>
            <new_values>
              <new_value>
                <column_name>ID</column_name>
                <data>
                  <varchar2>dummy2</varchar2>
                </data>
              </new_value>
              <new_value>
                <column_name>NUM</column_name>
                <data>
                  <number>2222</number>
                </data>
              </new_value>
            </new_values>
       </ROW_LCR>';

    lcrInXml := XMLType.createXML(lcrInText);
    lcrInAnyData := dbms_mgwmsg.xml_to_lcr(lcrInXml);
    
    -- Construct the message from its constituent parts.
    payload := lcrInAnyData;

    -- Enqueue the message.
    dbms_aq.enqueue(queue_name         => 'mgwuser.mgw_lcr_src',
                    enqueue_options    => enqueue_options,
                    message_properties => message_properties,
                    payload            => payload,
                    msgid              => msgid);
    commit;

    dbms_output.put_line('A ROW LCR has been sent to mgwuser.mgw_lcr.src');
  
end enqueue;
/
